<?php

namespace App\Controller;

use App\Entity\Parametres;
use App\Form\ParametresType;
use App\Managers\Managers;
use App\Repository\ParametresRepository;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/admin/parametres')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN")'))]
class AdminParametresController extends AbstractController
{
    public function __construct(
        private readonly Managers              $manager,
        private readonly FlashServiceInterface $flash,
        private readonly ParametresRepository  $parametresRepository,
    )
    {
    }

    #[Route('/', name: "admin.parametres.home", methods: ['GET'])]
    public function index(): Response
    {
        return $this->render('admin/parametres/index.html.twig', [
            'title' => 'Tous les paramètres',
        ]);
    }

    #[Route('/application/create', name: "admin.strucutre.create", methods: ['GET'])]
    public function new(): Response
    {
        $structure = new Parametres();
        $this->manager->setEntity($structure, 'new');
        $this->flash->success("Vous pouvez à présent renseigner vos donnée conçernant votre structure");
        return $this->redirectToRoute('admin.strucutre.edit', ['id' => $structure->getId()]);
    }

    #[Route('/edit/{id}', name: 'admin.strucutre.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function edit($id, Request $request): Response
    {
        $structure = $this->parametresRepository->find($id);
        $form = $this->createForm(ParametresType::class, $structure);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($structure, 'edit');
            $this->flash->success("Information(s) mises à jour(s) avec succès.");
            return $this->redirectToRoute('admin.strucutre.edit', ['id' => $structure->getId()]);
        }
        return $this->render('admin/parametres/applications/new.html.twig', [
            'structure' => $structure,
            'form' => $form->createView(),
            'title' => 'Paramètres de l\'application',
        ]);
    }
}
