<?php

namespace App\Controller;

use App\Entity\Emailclientsentreprises;
use App\Form\EmailEntreprisesType;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\Exception\TransportExceptionInterface;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Part\DataPart;
use Symfony\Component\Mime\Part\File;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE")'))]
class EmailEntreprisesController extends AbstractController
{
    public function __construct(
        private readonly MailerInterface       $mailer,
        private readonly FlashServiceInterface $flash,
    )
    {
    }

    #[Route('/entreprises/emails', name: "email.entreprises.index", methods: ['GET'])]
    public function index(Request $request): Response
    {
        $emailclients = new Emailclientsentreprises();
        $form = $this->createForm(EmailEntreprisesType::class, $emailclients);
        $form->handleRequest($request);

        return $this->render('dashboard/entreprises/emails/index.html.twig', [
            'emailclients' => $emailclients,
            'form' => $form->createView(),
            'active' => 'email.entreprises.index',
            'title' => 'Rédiger votre message',
        ]);
    }

    /**
     * @throws TransportExceptionInterface
     */
    #[Route('/entreprises/emails/send', name: "emailentreprise.send", methods: ['GET', 'POST'])]
    public function sendEmail(Request $request): Response
    {
        $emailclients = new Emailclientsentreprises();
        $form = $this->createForm(EmailEntreprisesType::class, $emailclients);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $status = false;
            if (isset($_FILES) && $_FILES) {
                $allowextensions = ['pdf', 'docx', 'doc', 'xsls', 'jpeg', 'png'];
                $files = [];
                $file_name = $_FILES['email_entreprises']['name']['filename'];
                $tmp_name = $_FILES['email_entreprises']['tmp_name']['filename'];
                $file_type = $_FILES['email_entreprises']['type']['filename'];
                $path_part = pathinfo($file_name);
                $ext = $path_part['extension'];

                if (!in_array($ext, $allowextensions)) {
                    $this->flash->danger("Une erreur est survenue.");
                }
                $files[] = $_FILES['email_entreprises'];

                $client = $form->get('clientsentreprises')->getData();
                $to = $form->get('email')->getData();

                $from = "infos@usimeca.ci";
                $objet = $form->get('objet')->getData();
                $message = $form->get('message')->getData();

                //On prepare les fichiers
                for ($x = 0; $x < count($files); $x++) {
                    $file = fopen($files[$x]['tmp_name']['filename'], "rb");
                    fclose($file);
                }
                //On envois le mail

                foreach ($to as $email) {
                    $messages = (new TemplatedEmail($objet))
                        ->from($from)
                        ->to($email->getEmail())
                        ->replyTo($from)
                        ->subject($objet)
                        ->setBody($message)
                        ->addPart(new DataPart(new File($tmp_name, $file_name)));
                    try {
                        $this->mailer->send($messages);
                        $status = true;
                    } catch (TransportExceptionInterface $e) {
                        $status = false;
                    }

                }

                if ($status) {
                    $this->flash->success("Email envoyé avec succès.");
                } else {
                    $this->flash->danger("Erreur d'envois du mail.");
                }
                return $this->redirectToRoute('clientsentreprises.index');
            }
        }

        return $this->render('dashboard/entreprises/emails/index.html.twig', [
            'form' => $form->createView(),
            'active' => 'email.entreprises.index',
            'title' => 'Rédiger votre message',
        ]);
    }
}
