<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\EtatsreglementsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;


#[ORM\Entity(repositoryClass: EtatsreglementsRepository::class)]
#[ORM\HasLifecycleCallbacks]
#[UniqueEntity(fields: 'name')]
class Etatsreglements
{
    use DatesTrait;
    use IdTrait;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $name = null;

    #[ORM\Column(type: 'string', length: 30, nullable: false)]
    #[Assert\NotBlank]
    private ?string $color = null;

    #[ORM\OneToMany(targetEntity: Proformaentreprises::class, mappedBy: 'modereglements')]
    private Collection $proformaentreprises;

    #[ORM\OneToMany(targetEntity: Proformaparticuliers::class, mappedBy: 'modereglements')]
    private Collection $proformaparticuliers;

    public function __construct()
    {
        $this->proformaentreprises = new ArrayCollection();
        $this->proformaparticuliers = new ArrayCollection();
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getColor(): ?string
    {
        return $this->color;
    }

    public function setColor(string $color): self
    {
        $this->color = $color;

        return $this;
    }

    /**
     * @return Collection<int, Proformaentreprises>
     */
    public function getProformaentreprises(): Collection
    {
        return $this->proformaentreprises;
    }

    public function addProformaentreprise(Proformaentreprises $proformaentreprise): self
    {
        if (!$this->proformaentreprises->contains($proformaentreprise)) {
            $this->proformaentreprises[] = $proformaentreprise;
            $proformaentreprise->setModereglements($this);
        }

        return $this;
    }

    public function removeProformaentreprise(Proformaentreprises $proformaentreprise): self
    {
        if ($this->proformaentreprises->contains($proformaentreprise)) {
            $this->proformaentreprises->removeElement($proformaentreprise);
            if ($proformaentreprise->getModereglements() === $this) {
                $proformaentreprise->setModereglements(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Proformaparticuliers>
     */
    public function getProformaparticuliers(): Collection
    {
        return $this->proformaparticuliers;
    }

    public function addProformaparticulier(Proformaparticuliers $proformaparticulier): self
    {
        if (!$this->proformaparticuliers->contains($proformaparticulier)) {
            $this->proformaparticuliers[] = $proformaparticulier;
            $proformaparticulier->setModereglements($this);
        }

        return $this;
    }

    public function removeProformaparticulier(Proformaparticuliers $proformaparticulier): self
    {
        if ($this->proformaparticuliers->contains($proformaparticulier)) {
            $this->proformaparticuliers->removeElement($proformaparticulier);
            if ($proformaparticulier->getModereglements() === $this) {
                $proformaparticulier->setModereglements(null);
            }
        }

        return $this;
    }

    public function __toString()
    {
        return $this->name;
    }
}
