<?php

namespace App\Components\Entreprises;

use App\Entity\Proformaentreprises;
use App\Form\Entreprises\AddProformaType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent('AddProformaEntrepriseFormComponent', template: 'components/entreprises/add_proforma_entreprise_form_component.html.twig')]
class AddProformaEntrepriseFormComponents extends AbstractController
{
    use DefaultActionTrait;
    use ComponentWithFormTrait;

    #[LiveProp]
    public ?Proformaentreprises $facture = null;

    protected function instantiateForm(): FormInterface
    {
        return $this->createForm(AddProformaType::class, $this->facture);
    }
}