<?php

namespace App\Controller\Admin;

use App\Entity\Etatsfactures;
use App\Form\EtatsfacturesType;
use App\Managers\Managers;
use App\Repository\EtatsfacturesRepository;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/etatsfactures')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN")'))]
class AdminEtatsfacturesController extends AbstractController
{
    public function __construct(
        private readonly Managers              $manager,
        private readonly FlashServiceInterface $flash,
    )
    {
    }

    #[Route('/', name: "admin.etatsfactures.index", methods: ['GET', 'POST'])]
    public function index(EtatsfacturesRepository $etatsfacturesRepository, Request $request): Response
    {
        $etatsfacture = new Etatsfactures();
        $form = $this->createForm(EtatsfacturesType::class, $etatsfacture);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($etatsfacture, 'new');
            $this->flash->success("Enrégistrement effectué avec succès.");
            return $this->redirectToRoute('admin.etatsfactures.index');
        }

        return $this->render('admin/etatsfactures/index.html.twig', [
            'etatsfacture' => $etatsfacture,
            'form' => $form->createView(),
            'etatsfactures' => $etatsfacturesRepository->findAll(),
            'title' => 'Liste Etats de facture',
            'libelle_ajouter' => 'Nouvelle etat de facture',
            'active' => 'admin.etatsfactures.index',
        ]);
    }

    #[Route('/new', name: "admin.etatsfactures.new", methods: ['GET', 'POST'])]
    public function new(Request $request): Response
    {
        $etatsfacture = new Etatsfactures();
        $form = $this->createForm(EtatsfacturesType::class, $etatsfacture);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($etatsfacture, 'new');
            $this->flash->success("Enrégistrement effectué avec succès.");
            return $this->redirectToRoute('admin.etatsfactures.index');
        }

        return $this->render('admin/etatsfactures/new.html.twig', [
            'etatsfacture' => $etatsfacture,
            'form' => $form->createView(),
            'title' => 'Liste des etats de facture',
            'libelle_liste' => 'Liste des etats de facture',
            'libelle_ajouter' => 'Nouvelle etat de facture',
            'active' => 'admin.etatsfactures.index',
        ]);
    }

    #[Route('/{id}/edit', name: 'admin.etatsfactures.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function edit(Request $request, Etatsfactures $etatsfacture): Response
    {
        $form = $this->createForm(EtatsfacturesType::class, $etatsfacture);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($etatsfacture, 'edit');
            $this->flash->success("Modification effectuée avec succès.");
            return $this->redirectToRoute('admin.etatsfactures.index', [
                'id' => $etatsfacture->getId(),
            ]);
        }

        return $this->render('admin/etatsfactures/edit.html.twig', [
            'etatsfacture' => $etatsfacture,
            'form' => $form->createView(),
            'title' => 'Editer un etat de facture',
            'libelle_ajouter' => 'Nouvelle etat de facture',
            'libelle_liste' => 'Liste des etats de facture',
            'active' => 'admin.etatsfactures.edit',
        ]);
    }

    #[Route('/{id}', name: 'admin.etatsfactures.delete', requirements: ['id' => Requirement::DIGITS], methods: ['DELETE'])]
    public function delete(Request $request, Etatsfactures $etatsfacture): Response
    {
        if ($this->isCsrfTokenValid('delete' . $etatsfacture->getId(), $request->request->get('_token'))) {
            $this->manager->setEntity($etatsfacture, 'delete');
            $this->flash->success("Suppression effectuée avec succès.");
        }

        return $this->redirectToRoute('admin.etatsfactures.index');
    }
}
