<?php

namespace App\Controller\Admin;

use App\Entity\Typesclients;
use App\Form\TypesclientsType;
use App\Managers\Managers;
use App\Repository\TypesclientsRepository;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/typesclients')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN")'))]
class AdminTypesclientsController extends AbstractController
{
    public function __construct(
        private readonly Managers              $manager,
        private readonly FlashServiceInterface $flash,
    )
    {
    }

    #[Route('/', name: "admin.typesclients.index", methods: ['GET', 'POST'])]
    public function index(TypesclientsRepository $typesclientsRepository, Request $request): Response
    {
        $typesclient = new Typesclients();
        $form = $this->createForm(TypesclientsType::class, $typesclient);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($typesclient, 'new');
            $this->flash->success("Enrégistrement effectué avec succès.");
            return $this->redirectToRoute('admin.typesclients.index');
        }

        return $this->render('admin/typesclients/index.html.twig', [
            'typesclient' => $typesclient,
            'form' => $form->createView(),
            'typesclients' => $typesclientsRepository->findAll(),
            'title' => 'Liste des types de client',
            'libelle_ajouter' => 'Nouveau type de client',
            'active' => 'admin.typesclients.index',
        ]);
    }

    #[Route('/new', name: "admin.typesclients.new", methods: ['GET', 'POST'])]
    public function new(Request $request): Response
    {
        $typesclient = new Typesclients();
        $form = $this->createForm(TypesclientsType::class, $typesclient);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($typesclient, 'new');
            $this->flash->success("Enrégistrement effectué avec succès.");
            return $this->redirectToRoute('admin.typesclients.index');
        }

        return $this->render('admin/typesclients/new.html.twig', [
            'typesclient' => $typesclient,
            'form' => $form->createView(),
            'title' => 'Liste des types de client',
            'libelle_liste' => 'Liste des types de client',
            'libelle_ajouter' => 'Nouveau type de client',
            'active' => 'admin.typesclients.index',
        ]);
    }

    #[Route('/{id}/edit', name: 'admin.typesclients.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function edit(Request $request, Typesclients $typesclient): Response
    {
        $form = $this->createForm(TypesclientsType::class, $typesclient);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($typesclient, 'edit');
            $this->flash->success("Modification effectuée avec succès.");
            return $this->redirectToRoute('admin.typesclients.index', [
                'id' => $typesclient->getId(),
            ]);
        }

        return $this->render('admin/typesclients/edit.html.twig', [
            'typesclient' => $typesclient,
            'form' => $form->createView(),
            'title' => 'Editer un type de client',
            'libelle_ajouter' => 'Nouveau type de client',
            'libelle_liste' => 'Liste des types de client',
            'active' => 'admin.typesclients.edit',
        ]);
    }

    #[Route('/{id}', name: 'admin.typesclients.delete', requirements: ['id' => Requirement::DIGITS], methods: ['DELETE'])]
    public function delete(Request $request, Typesclients $typesclient): Response
    {
        if ($this->isCsrfTokenValid('delete' . $typesclient->getId(), $request->request->get('_token'))) {
            $this->manager->setEntity($typesclient, 'delete');
            $this->flash->success("Suppression effectuée avec succès.");
        }

        return $this->redirectToRoute('admin.typesclients.index');
    }
}
