<?php

namespace App\Controller\Entreprises;

use App\Entity\Clientsentreprises;
use App\Form\ClientsentreprisesType;
use App\Managers\Managers;
use App\Repository\ClientsentreprisesRepository;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/entreprise/clients')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE")'))]
class ClientsentreprisesController extends AbstractController
{
    public function __construct(
        private readonly Managers              $manager,
        private readonly FlashServiceInterface $flash,
    )
    {
    }

    #[Route('/', name: "clientsentreprises.index", methods: ['GET'])]
    public function index(ClientsentreprisesRepository $clientsentreprisesRepository): Response
    {
        return $this->render('entreprises/clients/index.html.twig', [
            'clientsentreprises' => $clientsentreprisesRepository->findAll(),
            'title' => 'Clients',
            'active' => 'clientsentreprises.index',
        ]);
    }

    #[Route('/new', name: "clientsentreprises.new", methods: ['GET', 'POST'])]
    public function new(Request $request): Response
    {
        $clientsentreprise = new Clientsentreprises();
        $form = $this->createForm(ClientsentreprisesType::class, $clientsentreprise);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $clientsentreprise->setUsers($this->getUser());
            $this->manager->setEntity($clientsentreprise, 'new');
            $this->flash->success("Client ajouté avec succès.");
            return $this->redirectToRoute('clientsentreprises.index');
        }

        return $this->render('entreprises/clients/new.html.twig', [
            'clientsentreprise' => $clientsentreprise,
            'form' => $form->createView(),
            'title' => 'Liste des clients entreprises',
            'libelle_ajouter' => 'Nouveau client',
            'libelle_liste' => 'Liste des clients entreprises',
        ]);
    }

    #[Route('/{id}', name: 'clientsentreprises.show', requirements: ['id' => Requirement::DIGITS], methods: ['GET'])]
    public function show(Clientsentreprises $clientsentreprise): Response
    {
        return $this->render('entreprises/clients/show.html.twig', [
            'clientsentreprise' => $clientsentreprise,
            'title' => 'Fiche clients',
            'libelle_ajouter' => 'Nouveau client',
            'libelle_liste' => 'Liste des clients entreprises',
        ]);
    }

    #[Route('/{id}/edit', name: 'clientsentreprises.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function edit(Request $request, Clientsentreprises $clientsentreprise): Response
    {
        $form = $this->createForm(ClientsentreprisesType::class, $clientsentreprise);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $clientsentreprise->setUsers($this->getUser());
            $this->manager->setEntity($clientsentreprise, 'edit');
            $this->flash->success("Client modifié avec succès.");
            return $this->redirectToRoute('clientsentreprises.index', [
                'id' => $clientsentreprise->getId(),
            ]);
        }

        return $this->render('entreprises/clients/edit.html.twig', [
            'clientsentreprise' => $clientsentreprise,
            'form' => $form->createView(),
            'title' => 'Editer un client',
            'libelle_ajouter' => 'Nouveau client',
            'libelle_liste' => 'Liste des clients entreprises',
        ]);
    }

    #[Route('/{id}', name: 'clientsentreprises.delete', requirements: ['id' => Requirement::DIGITS], methods: ['DELETE'])]
    public function delete(Request $request, Clientsentreprises $clientsentreprise): Response
    {
        if ($this->isCsrfTokenValid('delete' . $clientsentreprise->getId(), $request->request->get('_token'))) {
            $this->manager->setEntity($clientsentreprise, 'delete');
            $this->flash->success("Client supprimé avec succès.");
        }

        return $this->redirectToRoute('clientsentreprises.index');
    }
}
