<?php

namespace App\Controller\Entreprises;

use App\Entity\Emailclientsentreprises;
use App\Form\Entreprises\EmailclientsentreprisesType;
use App\Managers\Managers;
use App\Repository\ClientsentreprisesRepository;
use App\Repository\EmailclientsentreprisesRepository;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/entreprise/emailclients')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE")'))]
class EntrepriseEmailClientsController extends AbstractController
{
    public function __construct(
        private readonly Managers                     $manager,
        private readonly FlashServiceInterface        $flash,
        private readonly ClientsentreprisesRepository $clientsentreprisesRepository,
    )
    {
    }

    #[Route('/', name: "admin.emailclientsentreprises.index", methods: ['GET', 'POST'])]
    public function index(Request $request, EmailclientsentreprisesRepository $emailclientsentreprisesRepository): Response
    {
        $emailclientsentreprise = new Emailclientsentreprises();
        $form = $this->createForm(EmailclientsentreprisesType::class, $emailclientsentreprise);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $emails = $form->get('email')->getData();
            $client = $this->clientsentreprisesRepository->find($form->get('clientsentreprises')->getData());
            $getEmailsExplodes = explode(';', $emails);
            foreach ($getEmailsExplodes as $email) {
                $emailclients = new Emailclientsentreprises();
                $emailclients->setEmail($email);
                $emailclients->setClientsentreprises($client);
                $this->manager->setEntity($emailclients, 'new');
            }
            $this->flash->success("Enrégistrement éffectué avec succès.");
            return $this->redirectToRoute('admin.emailclientsentreprises.index');
        }

        return $this->render('entreprises/emailclients/index.html.twig', [
            'emailclientsentreprise' => $emailclientsentreprise,
            'form' => $form->createView(),
            'emailclientsentreprises' => $emailclientsentreprisesRepository->findAll(),
            'title' => 'Liste emails',
            'libelle_ajouter' => 'Nouveau email',
            'active' => 'admin.emailclientsentreprises.index',
        ]);
    }

    #[Route('/new', name: "admin.emailclientsentreprises.new", methods: ['GET', 'POST'])]
    public function new(Request $request): Response
    {
        $emailclientsentreprise = new Emailclientsentreprises();
        $form = $this->createForm(EmailclientsentreprisesType::class, $emailclientsentreprise);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($emailclientsentreprise, 'new');
            $this->flash->success("Enrégistrement éffectué avec succès.");
            return $this->redirectToRoute('admin.emailclientsentreprises.index');
        }

        return $this->render('entreprises/emailclients/new.html.twig', [
            'emailclientsentreprise' => $emailclientsentreprise,
            'form' => $form->createView(),
            'title' => 'Liste des emails',
            'libelle_liste' => 'Liste des emails',
            'libelle_ajouter' => 'Nouveau email',
            'active' => 'admin.emailclientsentreprises.index',
        ]);
    }

    #[Route('/{id}/edit', name: 'admin.emailclientsentreprises.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function edit(Request $request, Emailclientsentreprises $emailclientsentreprise): Response
    {
        $form = $this->createForm(EmailclientsentreprisesType::class, $emailclientsentreprise);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->manager->setEntity($emailclientsentreprise, 'edit');
            $this->flash->success("Modification effectuée avec succès.");
            return $this->redirectToRoute('admin.emailclientsentreprises.index', [
                'id' => $emailclientsentreprise->getId(),
            ]);
        }

        return $this->render('entreprises/emailclients/edit.html.twig', [
            'emailclientsentreprise' => $emailclientsentreprise,
            'form' => $form->createView(),
            'title' => 'Editer un email',
            'libelle_ajouter' => 'Nouveau email',
            'libelle_liste' => 'Liste des emails',
            'active' => 'admin.emailclientsentreprises.edit',
        ]);
    }

    #[Route('/{id}', name: 'admin.emailclientsentreprises.delete', requirements: ['id' => Requirement::DIGITS], methods: ['DELETE'])]
    public function delete(Request $request, Emailclientsentreprises $emailclientsentreprise): Response
    {
        if ($this->isCsrfTokenValid('delete' . $emailclientsentreprise->getId(), $request->request->get('_token'))) {
            $this->manager->setEntity($emailclientsentreprise, 'delete');
            $this->flash->success("Suppression effectuée avec succès.");
        }

        return $this->redirectToRoute('admin.emailclientsentreprises.index');
    }
}
