<?php

namespace App\Controller;

use App\Entity\ClientsSearch;
use App\Entity\PeriodeProformaSearch;
use App\Entity\Proformaentreprises;
use App\Form\ClientsSearchType;
use App\Form\Entreprises\ProformaPeriodeType;
use App\Managers\Managers;
use App\Repository\ClientsentreprisesRepository;
use App\Repository\ProformaentreprisesRepository;
use App\Repository\ProformaparticuliersRepository;
use App\Services\Proforma\PeriodeProformaService;
use DateTime;
use Exception;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dashboard/searchs')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE") or is_granted("ROLE_PARTICULIER")'))]
class SearchController extends AbstractController
{
    public function __construct(
        private readonly Managers               $manager,
        private readonly PeriodeProformaService $periodeProformaService
    )
    {
    }

    #[Route('/entreprise', name: "search.home", methods: ['GET'])]
    public function indexEntreprises(): Response
    {
        return $this->render('entreprises/searchs/search.html.twig', [
            'clients' => null,
            'title' => 'Resultat recherche',
        ]);
    }

    #[Route('/particulier', name: "search.particuliers.home", methods: ['GET'])]
    public function indexParticuliers(): Response
    {
        return $this->render('particuliers/searchs/search.html.twig', [
            'clients' => null,
            'title' => 'Resultat recherche',
        ]);
    }

    #[Route('/entreprise/client', name: "clientsentreprises.search", methods: ['GET', 'POST'])]
    public function searchClient(Request $request, ClientsentreprisesRepository $clientsentreprisesRepository): Response
    {
        $search = new ClientsSearch();
        $form = $this->createForm(ClientsSearchType::class, $search);
        $form->handleRequest($request);
        $clients = null;

        if ($form->isSubmitted() && $form->isValid()) {
            $clients = $clientsentreprisesRepository->findClient($search);
            if (!$clients) {
                $client = null;
                return $this->redirectToRoute('search.home');
            }
        }

        return $this->render('entreprises/searchs/search.html.twig', [
            'search' => $search,
            'clients' => $clients,
            'title' => 'Resultat recherche pour : "' . $form->get('nom')->getData() . '"',
        ]);
    }

    /**
     * @throws Exception
     */
    #[Route('/facture/pdf-generate/by-periode', name: "proformaentreprise.periode.pdfddd", methods: ['GET', 'POST'])]
    public function proformaPeriodeFacturePDFAction(Request $request): Response
    {
        $search = new PeriodeProformaSearch();
        $form_periode = $this->createForm(ProformaPeriodeType::class, $search);
        $form_periode->handleRequest($request);
        $proformas = [];
        if ($form_periode->isSubmitted() && $form_periode->isValid()) {
            $datedebut = new DateTime($form_periode->get('datedebut')->getData() . ' 00:00:00');
            $datefin = new DateTime($form_periode->get('datefin')->getData() . ' 00:00:00');
            $proformas = $this->manager->getRepository(Proformaentreprises::class)->findProformaByPeriode($datedebut, $datefin);
        }
        if ($proformas == null) {
            $this->get('session')->getFlashBag()->add('danger', "Aucune facture disponible pour la période définie.");
            return $this->redirectToRoute('bilan.facture');
        }

        return $this->periodeProformaService->facture(
            proformas: $proformas,
            template: 'pdf/proformas/entreprises/periode_proformas.html.twig'
        );
    }

    #[Route('/generic-search', name: 'generic.search', methods: ['GET', 'POST'])]
    public function searchForm(
        Request                        $request,
        ProformaentreprisesRepository  $proformaentreprisesRepository,
        ProformaparticuliersRepository $proformaparticuliersRepository,
    ): Response
    {
        //Formulaire de recherche de clients
        $search = new ClientsSearch();
        $form = $this->createForm(ClientsSearchType::class, $search);
        $form->handleRequest($request);
        $search->page = $request->query->getInt('page', 1);
        $proformaparticuliers = [];
        $proformaentreprises = [];

        if ($search->getClientsType() === 'Particulier') {
            $proformaparticuliers = $proformaparticuliersRepository->recherche($search);
        } else {
            $proformaentreprises = $proformaentreprisesRepository->recherche($search);
        }

        return $this->render('searchs/search_generic.html.twig', [
            'client' => $search,
            'form' => $form->createView(),
            'title' => $search->q . ' - Recherche',
            'q' => $search->q,
            'typeClient' => $search->getClientsType(),
            'proformaparticuliers' => $proformaparticuliers,
            'proformaentreprises' => $proformaentreprises
        ]);
    }
}
