<?php

namespace App\Form\Entreprises;

use App\Entity\Emailclientsentreprises;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EmailclientsentreprisesType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('email', null, [
                'label' => 'Emails',
                'required' => true,
                'attr' => [
                    'placeholder' => 'Entrer un ou plusieurs emails séparés par ";"'
                ]
            ])
            ->add('clientsentreprises', null, [
                'required' => true,
                'placeholder' => 'Sélectionner un client',
                'attr' => ['class' => 'form-control'],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Emailclientsentreprises::class,
        ]);
    }
}
