<?php

namespace App\Form\Entreprises;

use App\Entity\PaniersEntreprise;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PaniersEntrepriseType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('designation', TextareaType::class, ['label' => 'Désignation', 'attr' => [
                'placeholder' => 'Désignation',
                'class' => 'input-xs',
            ]])
            ->add('quantite', null, ['label' => 'Quantité', 'attr' => [
                'placeholder' => 'Quantité',

                'class' => 'input-xs',
                'min' => 1,
                'max' => 99999,
            ]])
            ->add('pu', null, ['label' => 'Prix Unitaire', 'attr' => [
                'placeholder' => 'Prix unitaire',
                'class' => 'input-xs',
            ]]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => PaniersEntreprise::class,
        ]);
    }
}
