<?php

namespace App\Form\Particuliers;

use App\Entity\Proformaparticuliers;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class AddProformaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nom', null, ['label' => 'Nom et prenoms du client', 'attr' => [
                'placeholder' => 'Nom et prenoms du client',
                'class' => 'input-xs form-control',
            ]])
            ->add('datefacture', DateType::class, [
                'widget' => 'single_text',
                'html5' => false,
                'format' => 'dd/MM/yyyy',
                'attr' => [
                    'class' => 'input-xs daterange-single form-control'
                ]])
            ->add('telephone', null, ['label' => 'Téléphone du client', 'attr' => [
                'placeholder' => 'Téléphone du client',
                'class' => 'input-xs form-control',
            ]])
            ->add('adresse', null, ['label' => 'Adresse du client', 'attr' => [
                'placeholder' => 'Adresse du client',
                'class' => 'input-xs form-control',
            ]])
            ->add('email', null, ['label' => 'email du client', 'attr' => [
                'placeholder' => 'email du client',
                'class' => 'input-xs form-control',
            ]])
            ->add('departements', null, ['label' => 'Sélectionnez un département', 'placeholder' => 'Sélectionnez un département', 'attr' => [
                'class' => 'input-xs form-control',
            ]])
            ->add('titrefacture', null, ['label' => 'Objet', 'attr' => [
                'placeholder' => 'Objet de la facture',
                'class' => 'input-xs form-control',
            ]])
            ->add('recupere', null, ['label' => 'Recuperé ?',
                'attr' => [
                    'checked' => 'checked',
                    'class' => 'switchery switchery-default',
                ]])
            ->add('montantpaye', null, ['label' => 'Payé',
                'attr' => [
                    'class' => 'input-xs form-control',
                    'placeholder' => 'payé',
                ]])
            ->add('resteAPayer', null, ['label' => 'Reste à payer',
                'attr' => [
                    'class' => 'input-xs form-control',
                    'placeholder' => 'Reste à payer',

                ]])
            ->add('mentionvalidite', TextareaType::class, [
                'label' => 'Mention de validité',
                'data' => 'Cette proforma est valable  pour 30 jours à compter de la date d\'emission',
                'attr' => [
                    'placeholder' => 'Mention de validité',
                    'class' => 'input-xs form-control',
                ]]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Proformaparticuliers::class,
        ]);
    }
}
