<?php

namespace App\Services\Carts;

class CartItem
{
    private string $designation;
    private int $quantity;
    private float $price;

    public function __construct(string $designation, int $quantity, float $price)
    {
        $this->designation = $designation;
        $this->quantity = $quantity;
        $this->price = $price;
    }

    public function getDesignation(): string
    {
        return $this->designation;
    }

    public function setDesignation(string $designation): CartItem
    {
        $this->designation = $designation;
        return $this;
    }

    public function getQuantity(): int
    {
        return $this->quantity;
    }

    public function setQuantity(int $quantity): CartItem
    {
        $this->quantity = $quantity;
        return $this;
    }

    public function getPrice(): float
    {
        return $this->price;
    }

    public function setPrice(float $price): CartItem
    {
        $this->price = $price;
        return $this;
    }
    
}