<?php

namespace App\Controller;

use App\Entity\Proformaentreprises;
use App\Repository\ProformaentreprisesRepository;
use App\Services\Helpers\FlashServiceInterface;
use App\Services\Proforma\EntrepriseProformaService;
use Spipu\Html2Pdf\Exception\Html2PdfException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Error\SyntaxError;

#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN") or is_granted("ROLE_ENTREPRISE")'))]
class FacturesController extends AbstractController
{
    public function __construct(
        private readonly EntrepriseProformaService     $entrepriseProformaService,
        private readonly ProformaentreprisesRepository $proformaentreprisesRepository,
        private readonly FlashServiceInterface         $flash,
    )
    {
    }

    /**
     * @throws SyntaxError
     * @throws Html2PdfException
     * @throws RuntimeError
     * @throws LoaderError
     */
    #[Route('/facture/pdf-generate-proforma/{id}',
        name: "proformaentreprise.pdf",
        requirements: ['id' => Requirement::DIGITS],
        methods: ['GET']
    )]
    public function proformaFacturePDFAction(Proformaentreprises $proformaentreprises): Response
    {
        $facture = $this->proformaentreprisesRepository->findOneBy(['id' => $proformaentreprises->getId()]);
        if (!$facture) {
            $this->flash->danger("Proforma pas encore validée.");
            return $this->redirect($this->generateUrl('proformaentreprises.index'));
        }
        return $this->entrepriseProformaService->facture(
            proforma: $facture,
            template: 'pdf/proformas/entreprises/proformas.html.twig'
        );
    }

    /**
     * @throws SyntaxError
     * @throws Html2PdfException
     * @throws RuntimeError
     * @throws LoaderError
     */
    #[Route('/facture/pdf-generate/bonlivraison/{id}',
        name: "proformaentreprise.bonlivraison.pdf",
        requirements: ['id' => Requirement::DIGITS],
        methods: ['GET']
    )]
    public function bonLivraisonFacturePDFAction(Proformaentreprises $proformaentreprises): Response
    {
        $facture = $this->proformaentreprisesRepository->findOneBy(['id' => $proformaentreprises->getId()]);
        if (!$facture) {
            $this->flash->danger("Une erreur est survenue.");
            return $this->redirect($this->generateUrl('proformaentreprises.index'));
        }
        return $this->entrepriseProformaService->facture(
            proforma: $facture,
            template: 'pdf/proformas/entreprises/bonlivraison.html.twig'
        );
    }

    /**
     * @throws SyntaxError
     * @throws Html2PdfException
     * @throws RuntimeError
     * @throws LoaderError
     */
    #[Route('/facture/pdf/generate-facture-finale/{id}',
        name: "proformaentreprise.pdf.generate",
        requirements: ['id' => Requirement::DIGITS],
        methods: ['GET']
    )]
    public function factureGeneratePDFAction(Proformaentreprises $proformaentreprises): Response
    {
        $facture = $this->proformaentreprisesRepository->findOneBy(['id' => $proformaentreprises->getId()]);
        if (!$facture) {
            $this->flash->danger("Une erreur est survenue.");
            return $this->redirect($this->generateUrl('proformaentreprises.index'));
        }

        return $this->entrepriseProformaService->facture(
            proforma: $facture,
            template: 'pdf/proformas/entreprises/facture.html.twig'
        );
    }
}
