<?php

namespace App\Controller;

use App\Entity\ClientsSearch;
use App\Entity\PeriodeProformaSearch;
use App\Entity\Users;
use App\Form\ClientsSearchType;
use App\Form\Entreprises\ProformaPeriodeType;
use App\Form\UsersComptesType;
use App\Managers\Managers;
use App\Repository\ProformaentreprisesRepository;
use App\Services\Helpers\FlashServiceInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Routing\Requirement\Requirement;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/admin/logs')]
#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN")'))]
class LogsController extends AbstractController
{
    public function __construct(
        private readonly ProformaentreprisesRepository $proformaentreprisesRepository,
        private readonly Managers                      $manager,
        private readonly FlashServiceInterface         $flash,
    )
    {
    }

    #[Route('/', name: "admin.logs", methods: ['GET'])]
    public function index(): Response
    {
        return $this->render('admin/logs/index.html.twig', [
            'title' => 'Tous les logs',
        ]);
    }

    #[Route('/users/compte/{id}/edit', name: 'users.comptes.edit', requirements: ['id' => Requirement::DIGITS], methods: ['GET', 'POST'])]
    public function editCompte(Request $request, Users $user): Response
    {
        $form = $this->createForm(UsersComptesType::class, $user);
        $form->handleRequest($request);
        if ($form->isSubmitted()) {
            $user->setUsername(strtolower($form->get('username')->getData()));
            $user->setEmail(strtolower($form->get('email')->getData()));
            $this->manager->setEntity($user, 'edit');
            $this->flash->success("Modification effectuée avec succès.");
            return $this->redirectToRoute('users.comptes.edit', [
                'id' => $user->getId(),
            ]);
        }

        return $this->render('admin/utilisateurs/comptes/edit.html.twig', [
            'user' => $user,
            'form' => $form->createView(),
            'title' => 'Editer un mon compte',
            'active' => 'users.comptes.edit',
        ]);
    }

    public function getCountNewsProformaAdd(): Response
    {
        $proformas = $this->proformaentreprisesRepository->findBy(['statut' => false]);
        return $this->render('dashboard/includes/countNewsProformas.html.twig', [
            'countNewsProformas' => count($proformas),
        ]);
    }

    public function getNewsProformaAdd(): Response
    {
        $proformas = $this->proformaentreprisesRepository->findBy(['statut' => false], ['id' => 'DESC']);
        return $this->render('dashboard/includes/NewsProformasListe.html.twig', [
            'proformas' => $proformas,
        ]);
    }

    public function clientsSearchForm(Request $request): Response
    {
        //Formulaire de recherche de clients
        $search = new ClientsSearch();
        $form = $this->createForm(ClientsSearchType::class, $search);
        $form->handleRequest($request);
        return $this->render('dashboard/includes/clientsSearchForm.html.twig', [
            'client' => $search,
            'form' => $form->createView(),
        ]);
    }

    public function periodeProformaSearchForm(Request $request): Response
    {
        //Formulaire de génération de facture par période
        $search = new PeriodeProformaSearch();
        $form = $this->createForm(ProformaPeriodeType::class, $search);
        $form->handleRequest($request);
        return $this->render('dashboard/includes/periodeProformaSearchForm.html.twig', [
            'form_periode' => $form->createView(),
        ]);
    }
}
