<?php

namespace App\Form;

use App\Entity\Users;
use App\Enum\UserRoles;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Vich\UploaderBundle\Form\Type\VichImageType;

class UsersType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('username', null, ['label' => 'Nom utilisateur', 'attr' => [
                'placeholder' => 'Nom utilisateur',
                'class' => 'input-xs',
            ]])
            ->add('email', null, ['label' => 'Email de l\'utilisateur', 'attr' => [
                'placeholder' => 'Email de l\'utilisateur',
                'class' => 'input-xs',
            ]])
            ->add('password', null, ['label' => 'Mot de passe', 'attr' => [
                'placeholder' => 'Mot de passe',
                'class' => 'input-xs',
            ]])
            ->add('roles', ChoiceType::class, [
                'multiple' => true,
                'expanded' => true,
                'choices' => UserRoles::getRoles(),
                'label' => 'Rôle utilisateur',
                'attr' => ['class' => 'input-xs'],
            ])
            ->add('nomprenoms', null, ['label' => 'Nom et prénoms', 'attr' => [
                'placeholder' => 'Nom et prénoms de l\'utilisateur',
                'class' => 'input-xs'
            ]])
            ->add('contacts', null, ['label' => 'Contacts', 'attr' => [
                'placeholder' => 'Contacts de l\'utilisateur',
                'class' => 'input-xs'
            ]])
            ->add('adresse', null, ['label' => 'Adresse', 'attr' => [
                'placeholder' => 'Adresse de l\'utilisateur',
                'class' => 'input-xs'
            ]])
            ->add('imageFile', VichImageType::class, [
                'required' => false,
                'attr' => [
                    'class' => 'file-styled-primary'
                ],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Users::class,
        ]);
    }
}
