<?php

namespace App\Repository;

use App\Entity\Clientsentreprises;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Clientsentreprises>
 */
class ClientsentreprisesRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Clientsentreprises::class);
    }

    /**
     * @param $search
     * @return Clientsentreprises[]|null
     */
    public function findClient($search): ?array
    {
        return $this->createQueryBuilder('c')
            ->where('c.nom = :nom')
            ->setParameter('nom', $search)
            ->orWhere('c.rcc = :rcc')
            ->setParameter('rcc', $search)
            ->orWhere('c.telephone = :telephone')
            ->setParameter('telephone', $search)
            ->setMaxResults(1)
            ->getQuery()
            ->getResult();
    }
}
