<?php

namespace App\Services\Proforma;

use App\Entity\Parametres;
use App\Entity\Proformaentreprises;
use App\Repository\ParametresRepository;
use Spipu\Html2Pdf\Exception\Html2PdfException;
use Spipu\Html2Pdf\Html2Pdf;
use Symfony\Component\HttpFoundation\Response;
use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Error\SyntaxError;


readonly class PeriodeProformaService
{

    public function __construct(
        private ParametresRepository $parametresRepository,
        private Environment          $environment,
    )
    {
    }

    /**
     * @param Proformaentreprises[] $proformas
     * @param string $template
     * @return Response
     * @throws Html2PdfException
     * @throws LoaderError
     * @throws RuntimeError
     * @throws SyntaxError
     */
    public function facture(array $proformas, string $template): Response
    {
        $html2pdf = new Html2Pdf('P', 'A4', 'fr');
        $html2pdf->pdf->SetAuthor($this->getSociete()->getName());
        $html2pdf->pdf->SetTitle('Proformas regroupées');
        $html2pdf->pdf->SetSubject('Liste des proformas');
        $html2pdf->pdf->SetKeywords('proformas');
        $html2pdf->pdf->SetDisplayMode('real');

        foreach ($proformas as $proforma) {
            // Génère le HTML pour chaque `proforma`
            $html = $this->environment->render($template, [
                'facture' => $proforma,
                'societe' => $this->getSociete()
            ]);

            // Ajoute le contenu HTML au PDF en cours
            $html2pdf->writeHTML($html);

            // Optionnel : Ajouter une page blanche entre chaque proforma
            $html2pdf->pdf->AddPage();
        }

        // Nom du fichier pour le téléchargement
        $fileName = 'Proformas_regroupées.pdf';

        // Envoyer le fichier PDF au navigateur
        return new Response(
            $html2pdf->output($fileName, 'S'), // 'S' pour retourner le contenu du fichier en tant que chaîne
            200,
            ['Content-Type' => 'application/pdf']
        );
    }

    /**
     * Récupère les paramètres de la société
     * @return Parametres
     */
    private function getSociete(): Parametres
    {
        return $this->parametresRepository->find(1);
    }

}