<?php

namespace App\Controller\Admin;

use App\Entity\Mails;
use App\Form\MailsType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(new Expression('is_granted("ROLE_SUPER_ADMIN")'))]
class MailsController extends AbstractController
{
    public function mailsForm(Request $request): Response
    {
        //Formulaire pour envoyer un email
        $mail = new Mails();
        $form = $this->createForm(MailsType::class, $mail);
        $form->handleRequest($request);
        return $this->render('dashboard/includes/modal_quickEmail.html.twig', [
            'mail' => $mail,
            'form_mail' => $form->createView(),
        ]);
    }
}
