<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\ParametresRepository;
use DateTimeImmutable;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

#[ORM\Entity(repositoryClass: ParametresRepository::class)]
#[ORM\HasLifecycleCallbacks]
#[UniqueEntity(fields: 'name')]
#[Vich\Uploadable]
class Parametres
{
    use DatesTrait;
    use IdTrait;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $name = null;

    #[ORM\Column(type: 'string', length: 500, nullable: true)]
    private ?string $description = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $cc = null;

    #[ORM\Column(type: 'string', length: 500, nullable: true)]
    private ?string $regimeDImposition = null;

    #[ORM\Column(type: 'string', length: 500, nullable: true)]
    private ?string $centreDImposition = null;

    #[ORM\Column(type: 'string', length: 30, nullable: true)]
    private ?string $telephone = null;

    #[ORM\Column(type: 'string', length: 30, nullable: true)]
    private ?string $cellulaire = null;

    #[ORM\Column(type: 'string', length: 180, nullable: true)]
    private ?string $email = null;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $adresses = null;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $termes = null;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $complements = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $activite = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $slogan = null;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $factureheader = null;

    #[ORM\Column(type: 'text', nullable: true)]
    private ?string $facturefooter = null;

    #[Vich\UploadableField(mapping: "structures_logo", fileNameProperty: "filename")]
    #[Assert\Image(
        mimeTypes: ["image/png", "image/jpeg"],
        maxWidth: 206,
        maxHeight: 80,
    )]
    private ?File $imageFile = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $filename;

    #[Vich\UploadableField(mapping: "structures_signature", fileNameProperty: "signature")]
    #[Assert\Image(
        mimeTypes: ["image/png", "image/jpeg"],
        maxWidth: 320,
        maxHeight: 166,
    )]
    private ?File $imageFileSignature = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $signature = null;

    #[ORM\Column(type: 'string', length: 10, nullable: true)]
    private ?string $devise = null;

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getTelephone(): ?string
    {
        return $this->telephone;
    }

    public function setTelephone(?string $telephone): self
    {
        $this->telephone = $telephone;

        return $this;
    }

    public function getCellulaire(): ?string
    {
        return $this->cellulaire;
    }

    public function setCellulaire(?string $cellulaire): self
    {
        $this->cellulaire = $cellulaire;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getAdresses(): ?string
    {
        return $this->adresses;
    }

    public function setAdresses(?string $adresses): self
    {
        $this->adresses = $adresses;

        return $this;
    }

    public function getTermes(): ?string
    {
        return $this->termes;
    }

    public function setTermes(?string $termes): self
    {
        $this->termes = $termes;

        return $this;
    }

    public function getComplements(): ?string
    {
        return $this->complements;
    }

    public function setComplements(?string $complements): self
    {
        $this->complements = $complements;

        return $this;
    }

    public function getActivite(): ?string
    {
        return $this->activite;
    }

    public function setActivite(?string $activite): self
    {
        $this->activite = $activite;

        return $this;
    }

    public function getSlogan(): ?string
    {
        return $this->slogan;
    }

    public function setSlogan(?string $slogan): self
    {
        $this->slogan = $slogan;

        return $this;
    }

    public function getFactureheader(): ?string
    {
        return $this->factureheader;
    }

    public function setFactureheader(?string $factureheader): self
    {
        $this->factureheader = $factureheader;

        return $this;
    }

    public function getFacturefooter(): ?string
    {
        return $this->facturefooter;
    }

    public function setFacturefooter(?string $facturefooter): self
    {
        $this->facturefooter = $facturefooter;

        return $this;
    }

    public function getImageFile(): ?File
    {
        return $this->imageFile;
    }

    public function setImageFile(?File $imageFile): Parametres
    {
        $this->imageFile = $imageFile;
        if ($this->imageFile instanceof UploadedFile) {
            $this->updatedAt = new DateTimeImmutable('now');
        }
        return $this;
    }

    public function getFilename(): ?string
    {
        return $this->filename;
    }

    public function setFilename(?string $filename): self
    {
        $this->filename = $filename;

        return $this;
    }

    public function getImageFileSignature(): ?File
    {
        return $this->imageFileSignature;
    }

    public function setImageFileSignature(?File $imageFileSignature): Parametres
    {
        $this->imageFileSignature = $imageFileSignature;
        if ($this->imageFileSignature instanceof UploadedFile) {
            $this->updatedAt = new DateTimeImmutable('now');
        }
        return $this;
    }

    public function getSignature(): ?string
    {
        return $this->signature;
    }

    public function setSignature(?string $signature): self
    {
        $this->signature = $signature;

        return $this;
    }

    public function getDevise(): ?string
    {
        return $this->devise;
    }

    public function setDevise(?string $devise): self
    {
        $this->devise = $devise;

        return $this;
    }

    public function getCc(): ?string
    {
        return $this->cc;
    }

    public function setCc(?string $cc): self
    {
        $this->cc = $cc;

        return $this;
    }

    public function getRegimeDImposition(): ?string
    {
        return $this->regimeDImposition;
    }

    public function setRegimeDImposition(?string $regimeDImposition): self
    {
        $this->regimeDImposition = $regimeDImposition;

        return $this;
    }

    public function getCentreDImposition(): ?string
    {
        return $this->centreDImposition;
    }

    public function setCentreDImposition(?string $centreDImposition): self
    {
        $this->centreDImposition = $centreDImposition;

        return $this;
    }

    public function __toString(): string
    {
        return $this->name;
    }
}
