<?php

namespace App\Entity;

use App\Entity\Common\DatesTrait;
use App\Entity\Common\IdTrait;
use App\Repository\ProformaentreprisesRepository;
use DateTime;
use DateTimeImmutable;
use DateTimeInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

#[ORM\Entity(repositoryClass: ProformaentreprisesRepository::class)]
#[ORM\HasLifecycleCallbacks]
#[Vich\Uploadable]
#[UniqueEntity(fields: 'numero')]
class Proformaentreprises
{
    use DatesTrait;
    use IdTrait;

    const ETATPAIEMENTS = [
        0 => 'Non payée',
        1 => 'Partielle',
        2 => 'Payée',
    ];
    const STATUTPROFORMA = [
        0 => 'Annuleé',
        1 => 'En attente de validation',
        2 => 'Validée',
    ];
    #[ORM\ManyToOne(targetEntity: Clientsentreprises::class)]
    private ?Clientsentreprises $clientsentreprises = null;

    #[ORM\Column(type: 'integer', length: 15, nullable: false)]
    #[Assert\NotBlank]
    private ?int $numero;

    #[ORM\Column(type: 'string', length: 4, nullable: true)]
    private ?string $annee;

    #[ORM\Column(type: 'date')]
    #[Assert\NotBlank]
    private ?DateTimeInterface $datefacture;

    #[ORM\Column(type: 'string', length: 255, nullable: false)]
    #[Assert\NotBlank]
    private ?string $titrefacture = null;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $totalht = 0;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $totalttc = 0;

    #[ORM\Column(type: 'text', nullable: false)]
    #[Assert\NotBlank]
    private ?string $montantlettre = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $numeroBonDeCommande = null;

    #[ORM\Column(type: 'date', nullable: true)]
    private ?DateTimeInterface $dateBonDeCommande = null;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $tva = 0;

    #[ORM\Column(type: 'float', nullable: true)]
    private ?float $remise = 0;

    #[ORM\Column(type: 'boolean', nullable: true, options: ['default' => false])]
    private ?bool $valider = false;

    #[ORM\Column(type: 'boolean', nullable: true, options: ['default' => false])]
    private ?bool $statut = false;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $observationSurFacture = null;

    #[ORM\Column(type: 'text', nullable: false)]
    private ?string $mentionvalidite = null;

    #[ORM\Column(type: 'string', length: 30, nullable: false)]
    private ?string $numerolabelle = null;

    #[ORM\Column(type: 'integer', nullable: false)]
    private ?int $etat = 0;

    #[Vich\UploadableField(mapping: "boncommande_file", fileNameProperty: "attacheboncommande")]
    #[Assert\File(
        maxSize: '1024k',
        mimeTypes: ["application/pdf", "application/x-pdf"],
        mimeTypesMessage: "Veuillez sélectionner un fichier valide"
    )]
    private ?File $documentFile = null;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $attacheboncommande = null;

    #[ORM\Column(type: 'datetime', nullable: false)]
    private ?DateTimeInterface $datecreation;

    #[ORM\Column(type: 'integer', nullable: false)]
    private ?int $statutproforma;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $montantpaye = 0;

    #[ORM\Column(type: 'string', length: 255, nullable: true)]
    private ?string $nomdemandeur = null;

    #[ORM\Column(type: Types::FLOAT, precision: 10, scale: 0, nullable: true, options: ['default' => 0])]
    private ?float $resteAPayer = 0;

    #[ORM\Column(type: 'array', nullable: false)]
    private array $produits = [];

    #[ORM\ManyToOne(targetEntity: Users::class, inversedBy: 'proformaentreprises')]
    private ?Users $users = null;

    #[ORM\ManyToOne(targetEntity: Clientsentreprises::class, inversedBy: 'proformaentreprises')]
    private ?Clientsentreprises $clients = null;

    #[ORM\ManyToOne(targetEntity: Etatsreglements::class, inversedBy: 'proformaentreprises')]
    private ?Etatsreglements $modereglements = null;

    #[ORM\OneToMany(targetEntity: PaiementEntreprise::class, mappedBy: 'proformaentreprise')]
    private Collection $paiementEntreprises;

    public function __construct()
    {
        $this->datecreation = new DateTime('now');
        $this->statutproforma = 1;
        $this->annee = date('Y');
        $this->paiementEntreprises = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAnnee(): ?string
    {
        return $this->annee;
    }

    public function setAnnee(string $annee): self
    {
        $this->annee = $annee;

        return $this;
    }

    public function getNumero(): ?int
    {
        return $this->numero;
    }

    public function setNumero(int $numero): self
    {
        $this->numero = $numero;

        return $this;
    }

    public function getDatefacture(): ?DateTimeInterface
    {
        return $this->datefacture;
    }

    public function setDatefacture(DateTimeInterface $datefacture): self
    {
        $this->datefacture = $datefacture;

        return $this;
    }

    public function getTitrefacture(): ?string
    {
        return $this->titrefacture;
    }

    public function setTitrefacture(string $titrefacture): self
    {
        $this->titrefacture = $titrefacture;

        return $this;
    }

    public function getTotalht(): ?int
    {
        return $this->totalht;
    }

    public function setTotalht(int $totalht): self
    {
        $this->totalht = $totalht;

        return $this;
    }

    public function getTotalttc(): ?int
    {
        return $this->totalttc;
    }

    public function setTotalttc(int $totalttc): self
    {
        $this->totalttc = $totalttc;

        return $this;
    }

    public function getMontantlettre(): ?string
    {
        return $this->montantlettre;
    }

    public function setMontantlettre(string $montantlettre): self
    {
        $this->montantlettre = $montantlettre;

        return $this;
    }

    public function getClients(): ?Clientsentreprises
    {
        return $this->clients;
    }

    public function setClients(?Clientsentreprises $clients): self
    {
        $this->clients = $clients;

        return $this;
    }

    public function getTva(): ?float
    {
        return $this->tva;
    }

    public function setTva(?float $tva): self
    {
        $this->tva = $tva;

        return $this;
    }

    public function getRemise(): ?float
    {
        return $this->remise;
    }

    public function setRemise(?float $remise): Proformaentreprises
    {
        $this->remise = $remise;
        return $this;
    }

    public function getProduits(): ?array
    {
        return $this->produits;
    }

    public function setProduits(array $produits): self
    {
        $this->produits = $produits;

        return $this;
    }

    public function getUsers(): ?Users
    {
        return $this->users;
    }

    public function setUsers(?Users $users): self
    {
        $this->users = $users;

        return $this;
    }

    public function getValider(): ?bool
    {
        return $this->valider;
    }

    public function setValider(?bool $valider): self
    {
        $this->valider = $valider;

        return $this;
    }

    public function getObservationSurFacture(): ?string
    {
        return $this->observationSurFacture;
    }

    public function setObservationSurFacture(?string $observationSurFacture): self
    {
        $this->observationSurFacture = $observationSurFacture;

        return $this;
    }

    public function getStatut(): ?bool
    {
        return $this->statut;
    }

    public function setStatut(bool $statut): self
    {
        $this->statut = $statut;

        return $this;
    }

    public function getMentionvalidite(): ?string
    {
        return $this->mentionvalidite;
    }

    public function setMentionvalidite(string $mentionvalidite): self
    {
        $this->mentionvalidite = $mentionvalidite;

        return $this;
    }

    public function getNumerolabelle(): ?string
    {
        return $this->numerolabelle;
    }

    public function setNumerolabelle(string $numerolabelle): self
    {
        $this->numerolabelle = $numerolabelle;

        return $this;
    }

    public function getEtatPaiement(): string
    {
        return self::ETATPAIEMENTS[$this->etat];
    }

    public function getEtatProforma(): string
    {
        return self::STATUTPROFORMA[$this->statutproforma];
    }

    public function getEtat(): ?int
    {
        return $this->etat;
    }

    public function setEtat(int $etat): self
    {
        $this->etat = $etat;

        return $this;
    }

    public function getModereglements(): ?Etatsreglements
    {
        return $this->modereglements;
    }

    public function setModereglements(?Etatsreglements $modereglements): self
    {
        $this->modereglements = $modereglements;

        return $this;
    }

    /**
     * @return File|null
     */
    public function getDocumentFile(): ?File
    {
        return $this->documentFile;
    }

    public function setDocumentFile(?File $documentFile): Proformaentreprises
    {
        $this->documentFile = $documentFile;
        if ($this->documentFile instanceof UploadedFile) {
            $this->updatedAt = new DateTimeImmutable('now');
        }
        return $this;
    }

    public function getAttacheboncommande(): ?string
    {
        return $this->attacheboncommande;
    }

    public function setAttacheboncommande(?string $attacheboncommande): self
    {
        $this->attacheboncommande = $attacheboncommande;

        return $this;
    }

    public function getDatecreation(): ?DateTimeInterface
    {
        return $this->datecreation;
    }

    public function setDatecreation(DateTimeInterface $datecreation): self
    {
        $this->datecreation = $datecreation;

        return $this;
    }

    public function getStatutproforma(): ?int
    {
        return $this->statutproforma;
    }

    public function setStatutproforma(int $statutproforma): self
    {
        $this->statutproforma = $statutproforma;

        return $this;
    }

    public function getNomdemandeur(): ?string
    {
        return $this->nomdemandeur;
    }

    public function setNomdemandeur(?string $nomdemandeur): self
    {
        $this->nomdemandeur = $nomdemandeur;

        return $this;
    }

    public function getClientsentreprises(): ?Clientsentreprises
    {
        return $this->clientsentreprises;
    }

    public function setClientsentreprises(Clientsentreprises $clientsentreprises): self
    {
        $this->clientsentreprises = $clientsentreprises;

        return $this;
    }

    public function getMontantpaye(): ?int
    {
        return $this->montantpaye;
    }

    public function setMontantpaye(?int $montantpaye): self
    {
        $this->montantpaye = $montantpaye;

        return $this;
    }

    public function getResteAPayer(): ?int
    {
        return $this->resteAPayer;
    }

    public function setResteAPayer(?int $resteAPayer): self
    {
        $this->resteAPayer = $resteAPayer;

        return $this;
    }

    public function getNumeroBonDeCommande(): ?string
    {
        return $this->numeroBonDeCommande;
    }

    public function setNumeroBonDeCommande(?string $numeroBonDeCommande): self
    {
        $this->numeroBonDeCommande = $numeroBonDeCommande;

        return $this;
    }

    public function getDateBonDeCommande(): ?DateTimeInterface
    {
        return $this->dateBonDeCommande;
    }

    public function setDateBonDeCommande(DateTimeInterface $dateBonDeCommande): self
    {
        $this->dateBonDeCommande = $dateBonDeCommande;

        return $this;
    }

    /**
     * @return Collection<int, PaiementEntreprise>
     */
    public function getPaiementEntreprises(): Collection
    {
        return $this->paiementEntreprises;
    }

    public function addPaiementEntreprise(PaiementEntreprise $paiementEntreprise): self
    {
        if (!$this->paiementEntreprises->contains($paiementEntreprise)) {
            $this->paiementEntreprises[] = $paiementEntreprise;
            $paiementEntreprise->setProformaentreprise($this);
        }

        return $this;
    }

    public function removePaiementEntreprise(PaiementEntreprise $paiementEntreprise): self
    {
        if ($this->paiementEntreprises->contains($paiementEntreprise)) {
            $this->paiementEntreprises->removeElement($paiementEntreprise);
            if ($paiementEntreprise->getProformaentreprise() === $this) {
                $paiementEntreprise->setProformaentreprise(null);
            }
        }

        return $this;
    }

    /*#[ORM\PreUpdate]
    public function miseAJour(): void
    {
        $chiffreEnLettre = new ChiffreEnLettre();

        $montantlettre = strtoupper($chiffreEnLettre->Conversion($this->totalttc));
        $this->montantlettre = $montantlettre;

        $this->resteAPayer = $this->totalttc - $this->montantpaye;

    }*/
}
