<?php

namespace App\Form\Entreprises;

use App\Entity\PeriodeProformaSearch;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ProformaPeriodeType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('datedebut', null, ['label' => false, 'attr' => [
                'placeholder' => 'Date début',
                'class' => 'input-xs daterange-single',
                'autocomplete' => 'off',
            ]])
            ->add('datefin', null, ['label' => false, 'attr' => [
                'placeholder' => 'Date début',
                'class' => 'input-xs daterange-single',
                'autocomplete' => 'off',
            ]]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => PeriodeProformaSearch::class,
            'method' => 'post',
            'csrf_protection' => false,
        ]);
    }

    public function getBlockPrefix(): string
    {
        return '';
    }
}
