<?php

namespace App\Form;

use App\Entity\Etatsreglements;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EtatsreglementsType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('name', null, ['label' => 'Libéllé', 'attr' => [
                'placeholder' => 'Libéllé de l\'etat',
                'class' => 'input-xs',
            ]])
            ->add('color', null, ['label' => 'Color', 'attr' => [
                'class' => 'input-xs colorpicker-palette-hide',
            ]]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Etatsreglements::class,
        ]);
    }
}
