<?php

namespace App\Form;

use App\Entity\Parametres;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Vich\UploaderBundle\Form\Type\VichImageType;

class ParametresType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('name', null, ['label' => 'Nom de la structure', 'attr' => [
                'placeholder' => 'Nom de la structure',
            ]])
            ->add('telephone', null, ['label' => 'Numéro de téléphone', 'attr' => [
                'placeholder' => 'Numéro de téléphone',
            ]])
            ->add('cellulaire', null, ['label' => 'Numéro cellulaire', 'attr' => [
                'placeholder' => 'Numéro cellulaire',
            ]])
            ->add('email', null, ['label' => 'Email', 'attr' => [
                'placeholder' => 'Adresse Email',
            ]])
            ->add('activite', null, ['label' => 'Domaines d\'activité', 'attr' => [
                'placeholder' => 'Domaines d\'activité',
            ]])
            ->add('slogan', null, ['label' => 'Slogan', 'attr' => [
                'placeholder' => 'Slogan',
            ]])
            ->add('devise', null, ['label' => 'Dévise', 'attr' => [
                'placeholder' => 'Dévise',
                'value' => 'Fcfa',
            ]])
            ->add('description', TextareaType::class, array('label' => 'Apropos de la structure', 'required' => false, 'attr' => ['class' => 'summernote-height']))
            ->add('adresses', TextareaType::class, array('label' => 'Adresses et situation géographique', 'required' => false, 'attr' => ['class' => 'summernote-height']))
            ->add('complements', TextareaType::class, array('label' => 'Informations complémentaires', 'required' => false, 'attr' => ['class' => 'summernote-height']))
            ->add('factureheader', TextareaType::class, array('label' => 'Entête de facture', 'required' => false, 'attr' => ['class' => 'summernote-height']))
            ->add('facturefooter', TextareaType::class, array('label' => 'Bas de facture', 'required' => false, 'attr' => ['class' => 'summernote-height']))
            ->add('imageFile', VichImageType::class, [
                'required' => false,
            ])
            ->add('imageFileSignature', VichImageType::class, [
                'required' => false,
            ])
            ->add('termes', TextareaType::class, array('label' => 'Termes et conditions d\'utilisation', 'required' => false, 'attr' => ['class' => '']));
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Parametres::class,
        ]);
    }
}
