<?php

namespace App\Form;

use App\Entity\Users;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Vich\UploaderBundle\Form\Type\VichImageType;

class UsersComptesType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('username', null, ['label' => 'Nom utilisateur', 'attr' => [
                'placeholder' => 'Nom utilisateur',
                'class' => 'input-xs',
            ]])
            ->add('email', null, ['label' => 'Votre adresse email', 'attr' => [
                'placeholder' => 'Votre adresse email',
                'class' => 'input-xs',
            ]])
            ->add('nomprenoms', null, ['label' => 'Votre Nom et prénoms', 'attr' => [
                'placeholder' => 'Votre Nom et prénoms',
                'class' => 'input-xs'
            ]])
            ->add('contacts', null, ['label' => 'Numéro de téléphone', 'attr' => [
                'placeholder' => 'Numéro de téléphone',
                'class' => 'input-xs'
            ]])
            ->add('adresse', null, ['label' => 'Adresse', 'attr' => [
                'placeholder' => 'Adresse',
                'class' => 'input-xs'
            ]])
            ->add('imageFile', VichImageType::class, [
                'required' => false,
                'attr' => [
                    'class' => 'file-styled-primary'
                ],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Users::class,
        ]);
    }
}
