<?php

namespace App\Repository;

use App\Entity\PaniersEntreprise;
use App\Entity\Proformaentreprises;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<PaniersEntreprise>
 */
class PaniersEntrepriseRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, PaniersEntreprise::class);
    }

    /**
     * @param Proformaentreprises $proformaentreprise
     * @return PaniersEntreprise[]|null
     */
    public function findAllForProforma(Proformaentreprises $proformaentreprise): ?array
    {
        return $this->createQueryBuilder('p')
            ->where('p.id = :id')
            ->setParameter('id', $proformaentreprise->getId())
            ->getQuery()
            ->getResult();
    }

    public function findSumForProforma(Proformaentreprises $proformaentreprise)
    {
        return $this->createQueryBuilder('p')
            ->select('SUM(p.pt) as somme')
            ->where('p.id = :id')
            ->setParameter('id', $proformaentreprise->getId())
            ->getQuery()
            ->getSingleResult();
    }

    public function findSum()
    {
        return $this->createQueryBuilder('p')
            ->select('SUM(p.pt) as somme')
            ->getQuery()
            ->getSingleResult();
    }

    public function clearPaniers()
    {
        $em = $this->getEntityManager();
        $sql = "TRUNCATE TABLE panier";
        $query = $em->createQuery($sql);

        return $query->getResult();
    }
}
